<?php
namespace IssetBV\XAuthClient\Connection\Curl;

use IssetBV\XAuthClient\Payload\Payload;
use IssetBV\XAuthClient\Connection\ConnectionInterface;
use IssetBV\XAuthClient\Connection\ConnectionException;

class CurlPost implements ConnectionInterface
{

    private $curlOptConnectionTimeOut;

    private $curlOptTimeOut;

    function __construct($curlOptConnectionTimeOut = 2, $curlOptTimeOut = 8)
    {
        $this->curlOptConnectionTimeOut = $curlOptConnectionTimeOut;
        $this->curlOptTimeOut = $curlOptTimeOut;
    }

    public function sendPayload(Payload $payload)
    {
        $ch = curl_init($payload->getUrl());
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $this->curlOptConnectionTimeOut);
        curl_setopt($ch, CURLOPT_TIMEOUT, $this->curlOptTimeOut);
        
        if (in_array($payload->getMethod(), [
            'post',
            'put'
        ])) {
            curl_setopt($ch, CURLOPT_POST, 1);
            
            if ($payload->isJson()) {
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload->getPostData()));
            } else {
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload->getPostData());
            }
        }
        
        $headers = $payload->getHeaders();
        if (! empty($headers)) {
            $curlHeaders = array();
            foreach ($headers as $key => $value) {
                $curlHeaders[] = $key . ': ' . $value;
            }
            curl_setopt($ch, CURLOPT_HTTPHEADER, $curlHeaders);
        }
        
        $content = curl_exec($ch);
        if ($content === false) {
            throw new ConnectionException(curl_error($ch));
        }
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $retHeaders = substr($content, 0, $header_size);
        $body = substr($content, $header_size);
        
        return new CurlResponse(curl_getinfo($ch, CURLINFO_HTTP_CODE), $retHeaders, $body);
    }
}