<?php
namespace IssetBV\XAuthClient\Security;

use Exception;
use IssetBV\XAuthClient\Payload\PayloadFactory;
use IssetBV\XAuthClient\Security\Exception\TokenNotCreatedException;
use IssetBV\XAuthClient\Client;

/**
 * Class TokenCreater.
 */
class TokenCreater
{

    /**
     * @var Client
     */
    private $client;

    /**
     * @var PayloadFactory
     */
    private $payloadFactory;

    /**
     * TokenCreater constructor.
     * @param Client $client
     * @param PayloadFactory $payloadFactory
     */
    public function __construct(Client $client, PayloadFactory $payloadFactory)
    {
        $this->client = $client;
        $this->payloadFactory = $payloadFactory;
    }

    /**
     * @param string $consumerKey
     * @param string $privateKey
     * @return Token
     * @throws TokenNotCreatedException
     */
    public function getToken($consumerKey, $privateKey)
    {
        $payload = $this->payloadFactory->post('login');
        $time = time();
        $payload->setJson(true);
        $payload->setHeader('Content-Type', 'application/json');
        $payload->setPostData('consumer_key', $consumerKey);
        $payload->setPostData('time', $time);
        $payload->setPostData('hash', crypt($time . '' . $privateKey . '' . $consumerKey, '$6$rounds=9001$' . $consumerKey . '$'));
        try {
            $response = $this->client->sendPayload($payload);
        } catch (Exception $e) {
            throw new TokenNotCreatedException('send payload failed with message: ' . $e->getMessage());
        }

        if ($response->getStatusCode() < 200 && $response->getStatusCode() >= 300) {
            throw new TokenNotCreatedException('Response failed with status code: ' . $response->getStatusCode());
        }

        $response = $response->getJsonResponse();
        if ($response['token'] === null) {
            throw new TokenNotCreatedException('no token recieved');
        }

        return new Token($response['token'], array_key_exists('token_name', $response) ? $response['token_name'] : 'xauth-token');
    }
}