<?php
namespace IssetBV\XAuthClient;

use IssetBV\XAuthClient\Payload\Payload;
use IssetBV\XAuthClient\Connection\ConnectionInterface;
use IssetBV\XAuthClient\Connection\ResponseException;
use IssetBV\XAuthClient\Connection\ResponseInterface;
use IssetBV\XAuthClient\Security\Token;

/**
 * Class Client.
 */
class Client
{

    /**
     * @var ConnectionInterface
     */
    private $connection;

    /**
     * @param ConnectionInterface $connectionInterface
     */
    public function __construct(ConnectionInterface $connectionInterface)
    {
        $this->connection = $connectionInterface;
    }

    /**
     * Adds the security headers to the payload before sending them
     *
     * @param Payload $payload
     * @return ResponseInterface
     */
    public function sendPayloadWithToken(Payload $payload, Token $token)
    {
        $payload->setHeader($token->getTokenName(), $token->getToken());
        return $this->sendPayload($payload);
    }

    /**
     * @param Payload $payload
     * @return ResponseInterface
     */
    public function sendPayload(Payload $payload)
    {
        return $this->connection->sendPayload($payload);
    }
}