<?php
namespace IssetBV\XAuthClient\Security;

use IssetBV\XAuthClient\Security\TokenCreater;
use IssetBV\XAuthClient\Security\TokenVault;
use IssetBV\XAuthClient\Security\Exception\TokenNotFoundException;
use IssetBV\XAuthClient\Security\Token;
use IssetBV\XAuthClient\Security\Exception\TokenNotCreatedException;

class TokenManager
{

    private $tokenCreater;

    private $tokenVault;

    public function __construct(TokenCreater $tokenCreater, TokenVault $tokenVault)
    {
        $this->tokenCreater = $tokenCreater;
        $this->tokenVault = $tokenVault;
    }

    /**
     * @param string $consumerKey
     * @param string $privateKey
     * @throws TokenNotCreatedException
     * @return Token
     */
    public function getToken($consumerKey, $privateKey)
    {
        try {
            return $this->tokenVault->getToken($consumerKey);
        } catch (TokenNotFoundException $e) {
            $token = $this->tokenCreater->getToken($consumerKey, $privateKey);
            $this->tokenVault->addToken($consumerKey, $token);
            return $token;
        }
    }

    public function removeToken($consumerKey)
    {
        $this->tokenVault->removeToken($consumerKey);
    }
}