<?php
namespace IssetBV\XAuthClient\Payload;

class Payload
{

    protected $data = array();

    protected $headers = array();

    protected $url;

    protected $method;

    protected $json = false;

    public function __construct($url, $method = 'post')
    {
        $this->url = $url;
        $this->method = $method;
    }

    public function setJson($isJson)
    {
        $this->json = $isJson;
    }

    public function isJson()
    {
        return $this->json;
    }

    public function setUrl($url)
    {
        $this->url = $url;
        return $this;
    }

    public function getUrl()
    {
        return $this->url;
    }

    public function setHeader($header, $value)
    {
        $this->headers[$header] = $value;
        return $this;
    }

    public function getHeaders()
    {
        return $this->headers;
    }

    public function overwritePostData(array $data)
    {
        $this->data = $data;
    }

    public function setPostData($key, $value)
    {
        $this->data[$key] = $value;
        return $this;
    }

    public function getPostData()
    {
        return $this->data;
    }

    public function setMethod($method)
    {
        $this->method = $method;
        return $this;
    }

    public function getMethod()
    {
        return $this->method;
    }
}
