<?php
namespace IssetBV\XAuthClient\Security;

use LogicException;
use IssetBV\XAuthClient\Security\Exception\TokenNotFoundException;

class TokenVault
{

    private $tokenCacheLocation;

    public function __construct($tokenCacheLocation)
    {
        $this->tokenCacheLocation = rtrim($tokenCacheLocation, '/') . '/';
        if (! is_writable($tokenCacheLocation)) {
            throw new LogicException('token cache location isn\'t writable: ' . $tokenCacheLocation);
        }
    }

    public function addToken($key, Token $token)
    {
        file_put_contents($this->getPathForToken($key), serialize($token));
    }

    public function removeToken($key)
    {
        $location = $this->getPathForToken($key);
        if (file_exists($location)) {
            unlink($location);
        }
    }

    /**
     * @param string $key
     * @throws TokenNotFoundException
     * @return Token
     */
    public function getToken($key)
    {
        $location = $this->getPathForToken($key);
        if (! file_exists($location)) {
            throw new TokenNotFoundException("token not found");
        }
        return unserialize(file_get_contents($location));
    }

    public function getPathForToken($key)
    {
        return $this->tokenCacheLocation . sha1($key);
    }
}