<?php
namespace IssetBV\XAuthClient\Security;

use Exception;
use IssetBV\XAuthClient\Payload\PayloadFactory;
use IssetBV\XAuthClient\Security\Exception\TokenNotCreatedException;
use IssetBV\XAuthClient\Client;

class TokenCreater
{

    /**
     * @var Client
     */
    private $client;

    /**
     * @var PayloadFactory
     */
    private $payloadFactory;

    public function __construct(Client $client, PayloadFactory $payloadFactory)
    {
        $this->client = $client;
        $this->payloadFactory = $payloadFactory;
    }

    /**
     * @param string $consumerKey
     * @param string $privateKey
     * @return Token 
     * @throws TokenNotCreatedException
     */
    public function getToken($consumerKey, $privateKey)
    {
        try {
            $payload = $this->payloadFactory->post('login');
            $time = time();
            $payload->setJson(true);
            $payload->setHeader('Content-Type', 'application/json');
            $payload->setPostData('consumer_key', $consumerKey);
            $payload->setPostData('time', $time);
            $payload->setPostData('hash', crypt($time . '' . $privateKey . '' . $consumerKey, '$6$rounds=9001$' . $consumerKey . '$'));
            $response = $this->client->sendPayload($payload);
            if ($response->getStatusCode() >= 200 && $response->getStatusCode() < 300) {
                $response = $response->getJsonResponse();
                return new Token($response['token'], $response['token_name']);
            }
        } catch (Exception $e) {}
        throw new TokenNotCreatedException();
    }
}