<?php
namespace IssetBV\XAuthClient;

use IssetBV\XAuthClient\Security\TokenManager;
use IssetBV\XAuthClient\Payload\Payload;

class ClientToken
{

    /**
     * @var TokenManager
     */
    private $tokenManager;

    /**
     * @var Client
     */
    private $client;

    public function __construct(TokenManager $tokenManager, Client $client)
    {
        $this->tokenManager = $tokenManager;
        $this->client = $client;
    }

    public function sendPayload(ClientData $clientData, Payload $payload)
    {
        try {
            $token = $this->tokenManager->getToken($clientData->getConsumerKey(), $clientData->getPrivateKey());
            return $this->client->sendPayloadWithToken($payload, $token);
        } catch (Exception $e) {
            $this->tokenManager->removeToken($clientData->getConsumerKey());
            throw $e;
        }
    }
}