<?php
namespace IssetBV\XAuthBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use IssetBV\XAuthBundle\Model\LinkInterface;

/**
 * @ORM\Table(name="issetbv_xauth_endpoints")
 * @ORM\Entity(repositoryClass="IssetBV\XAuthBundle\Repository\EndpointRepository")
 */
class Endpoint
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="EndpointToken", mappedBy="endpoint", cascade={"persist"})
     */
    private $tokens;

    /**
     * @var LinkInterface
     * @ORM\ManyToOne(targetEntity="IssetBV\XAuthBundle\Model\LinkInterface")
     * @ORM\JoinColumn(nullable=false, onDelete="cascade")
     */
    private $link;

    /**
     * @var string
     * @ORM\Column(name="note", type="string", nullable=true)
     */
    private $note;

    /**
     * @var string
     * @ORM\Column(name="hasher", type="string", nullable=true)
     */
    private $hasher;

    /**
     * @var string
     * @ORM\Column(name="consumer_key", type="string", nullable=false, unique=true)
     */
    private $consumerKey;

    /**
     * @var string
     * @ORM\Column(name="private_key", type="string", nullable=false)
     */
    private $privateKey;

    /**
     * @var DateTime
     * @ORM\Column(name="date_deactivated", type="boolean", nullable=true)
     */
    private $dateDeactivated;

    /**
     * @var DateTime
     * @ORM\Column(name="created", type="datetime", nullable=true)
     */
    private $created;

    /**
     * @var DateTime
     * @ORM\Column(name="updated", type="datetime", nullable=true)
     */
    private $updated;

    /**
     * Constructor
     */
    public function __construct(LinkInterface $link, $consumerKey, $privateKey, $hasher = null)
    {
        $this->link = $link;
        $this->consumerKey = $consumerKey;
        $this->privateKey = $privateKey;
        $this->tokens = new ArrayCollection();
        $this->created = new DateTime();
        $this->updated = new DateTime();
        $this->hasher = $hasher;
    }

    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $token
     * @return EndpointToken
     */
    public function addToken($token)
    {
        $endpointToken = new EndpointToken($this, $token);
        $this->tokens->add($endpointToken);
        return $endpointToken;
    }

    /**
     * @return ArrayCollection
     */
    public function getTokens()
    {
        return $this->tokens;
    }

    /**
     * @return LinkInterface
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }

    /**
     * @return string
     */
    public function getConsumerKey()
    {
        return $this->consumerKey;
    }

    /**
     * @return string
     */
    public function getPrivateKey()
    {
        return $this->privateKey;
    }

    /**
     * @return DateTime
     */
    public function getDateDeactivated()
    {
        return $this->dateDeactivated;
    }

    /**
     * @return DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @return DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    public function getHasher()
    {
        return $this->hasher;
    }
}