<?php
namespace IssetBV\XAuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * EndpointToken
 *
 * @ORM\Table(name="issetbv_xauth_endpoint_tokens", indexes={@ORM\Index(name="token_search", columns={"token", "date_deactivated"})})
 * @ORM\Entity(repositoryClass="IssetBV\XAuthBundle\Repository\EndpointTokenRepository")
 */
class EndpointToken
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var Endpoint
     * @ORM\ManyToOne(targetEntity="Endpoint", inversedBy="tokens")
     * @ORM\JoinColumn(name="issetbv_xauth_endpoint_id", referencedColumnName="id", nullable=false, onDelete="cascade")
     */
    private $endpoint;

    /**
     * @var string
     * @ORM\Column(name="token", type="string", nullable=false, unique=true)
     */
    private $token;

    /**
     * @var DateTime
     * @ORM\Column(name="date_deactivated", type="boolean", nullable=true)
     */
    private $dateDeactivated;

    /**
     * @var DateTime
     * @ORM\Column(name="created", type="datetime", nullable=true)
     */
    private $created;

    /**
     * @var DateTime
     * @ORM\Column(name="updated", type="datetime", nullable=true)
     */
    private $updated;

    /**
     * @param Endpoint $endpoint
     * @param string $token
     */
    public function __construct(Endpoint $endpoint, $token)
    {
        $this->endpoint = $endpoint;
        $this->token = $token;
        $this->created = new DateTime();
        $this->updated = new DateTime();
    }

    /**
     * 
     */
    public function deactivate()
    {
        $this->dateDeactivated = new DateTime();
        $this->updated = new DateTime();
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->dateDeactivated === null;
    }

    /**
     * @return Endpoint
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * @return DateTime
     */
    public function getDateDeactivated()
    {
        return $this->dateDeactivated;
    }

    /**
     * @return DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @return DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }
}