<?php
namespace IssetBV\XAuthBundle\Security\Hasher;

use IssetBV\XAuthBundle\Entity\Endpoint;

class Factory
{

    /**
     * @var Hasher
     */
    private $defaultHasher;

    /**
     * 
     * @param Hasher[]
     */
    private $hashers;

    /**
     * @param Hasher $defaultHasher
     */
    public function __construct(Hasher $defaultHasher)
    {
        $this->defaultHasher = $defaultHasher;
        $this->hashers = [
            new Blowfish(),
            new Hmac(),
            new Sha1(),
            new Sha512(),
            new Sha512Hash()
        ];
    }

    /**
     * @param Endpoint $endpoint
     * @throws NoHasherException
     * @return Hasher
     */
    public function getHasher(Endpoint $endpoint, $hasherOverwrite = null)
    {
        $hasherName = $endpoint->getHasher();
        
        if (!empty($hasherOverwrite)) {
            switch ($hasherOverwrite) {
                case 'hmac':
                    return $this->getHasherByName('hmac');
                case 'sha512':
                    return $this->getHasherByName('sha512');
                case 'sha512_hash':
                    return $this->getHasherByName('sha512_hash');
                default:
                    throw new NoHasherException($hasherOverwrite);
            }
        }
        
        if (empty($hasherName)) {
            return $this->defaultHasher;
        }
        
        return $this->getHasherByName($hasherName);
    }

    /**
     * @param string $hasherName
     * @throws NoHasherException
     * @return Hasher
     */
    public function getHasherByName($hasherName)
    {
        foreach ($this->hashers as $hasher) {
            if ($hasher->getName() === $hasherName) {
                return $hasher;
            }
        }
        throw new NoHasherException($hasherName);
    }

    /**
     * @param Hasher $hasher
     */
    public function addHasher(Hasher $hasher)
    {
        $this->hashers[] = $hasher;
    }
}