<?php

namespace IssetBV\XAuthBundle\Security\Firewall;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Http\Firewall\ListenerInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\SecurityContextInterface;
use Symfony\Component\Security\Core\Authentication\AuthenticationManagerInterface;
use IssetBV\XAuthBundle\Security\Authentication\Token\XAuthToken;

class XAuthListener implements ListenerInterface
{

    /**
     * @var TokenStorageInterface
     */
    protected $tokenStorage;
    /**
     * @var AuthenticationManagerInterface
     */
    protected $authenticationManager;
    /**
     * @var string
     */
    protected $tokenName;

    /**
     * XAuthListener constructor.
     * @param TokenStorageInterface $tokenStorage
     * @param AuthenticationManagerInterface $authenticationManager
     * @param $tokenName
     */
    public function __construct(TokenStorageInterface $tokenStorage, AuthenticationManagerInterface $authenticationManager, $tokenName)
    {
        $this->tokenStorage = $tokenStorage;
        $this->authenticationManager = $authenticationManager;
        $this->tokenName = $tokenName;
    }

    public function handle(GetResponseEvent $event)
    {

        $request = $event->getRequest();
        $token = new XAuthToken(array(), $request->headers->get($this->tokenName, false));

        try {
            $authToken = $this->authenticationManager->authenticate($token);
            $this->tokenStorage->setToken($authToken);
        } catch (AuthenticationException $failed) {
            die('123123');
            $response = new JsonResponse(array('message' => $failed->getMessage()), 403);
            $event->setResponse($response);
        }
    }

}