<?php
namespace IssetBV\XAuthBundle\Security\Hasher;

use IssetBV\XAuthBundle\Entity\Endpoint;

class Factory
{

    /**
     * @var Hasher
     */
    private $defaultHasher;

    /**
     * 
     * @param Hasher[]
     */
    private $hashers;

    /**
     * @param Hasher $defaultHasher
     */
    public function __construct(Hasher $defaultHasher)
    {
        $this->defaultHasher = $defaultHasher;
        $this->hashers = [
            new Blowfish(),
            new Hmac(),
            new Sha1(),
            new Sha512(),
            new Sha512Hash()
        ];
    }

    /**
     * @param Endpoint $endpoint
     * @throws NoHasherException
     * @return Hasher
     */
    public function getHasher(Endpoint $endpoint)
    {
        $hasherName = $endpoint->getHasher();
        if (empty($hasherName)) {
            return $this->defaultHasher;
        }
        foreach ($this->hashers as $hasher) {
            if ($hasher->getName() === $hasherName) {
                return $hasher;
            }
        }
        throw new NoHasherException();
    }

    /**
     * @param Hasher $hasher
     */
    public function addHasher(Hasher $hasher)
    {
        $this->hashers[] = $hasher;
    }
}