<?php
namespace IssetBV\XAuthBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use IssetBV\XAuthBundle\Entity\Endpoint;
use IssetBV\XAuthBundle\Model\LinkInterface;

/**
 * Class EndpointRepository.
 *
 * @author Felix Balfoort <felix@isset.nl>
 * @author Bart Malestein <bart@isset.nl>
 */
class EndpointRepository extends EntityRepository
{

    /**
     * @param LinkInterface $linkInterface
     * @return Endpoint
     */
    public function findActiveByLinkInterface(LinkInterface $linkInterface)
    {
        return $this->createQueryBuilder('e')
            ->where("e.link = :link")
            ->andWhere('e.dateDeactivated IS NULL')
            ->setParameter('link', $linkInterface)
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult();
    }

    /**
     * @param LinkInterface $linkInterface
     * @param $hasher
     * @return Endpoint|null
     * @throws NonUniqueResultException
     */
    public function findActiveByLinkAndHasher(LinkInterface $linkInterface, $hasher)
    {
        $qb = $this->createQueryBuilder('e');
        $qb->where('e.link = :link');
        $qb->andWhere('e.hasher = :hasher');
        $qb->andWhere('e.dateDeactivated IS NULL');
        $qb->setParameter('link', $linkInterface);
        $qb->setParameter('hasher', $hasher);
        $qb->setMaxResults(1);

        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
     * @param $consumerKey
     * @return Endpoint
     */
    public function getByConsumerKey($consumerKey)
    {
        return $this->createQueryBuilder('e')
            ->where("e.consumerKey = :consumerKey")
            ->andWhere('e.dateDeactivated IS NULL')
            ->setParameter('consumerKey', $consumerKey)
            ->getQuery()
            ->getOneOrNullResult();
    }

    /**
     * @param $token
     * @return Endpoint
     */
    public function getByToken($token)
    {
        $endpoint = $this->createQueryBuilder('e')
            ->join('e.tokens', 't')
            ->where('e.dateDeactivated IS NULL')
            ->andWhere('t.token = :token')
            ->andWhere('t.dateDeactivated IS NULL')
            ->setParameter(':token', $token)
            ->getQuery()
            ->getOneOrNullResult();

        return $endpoint;
    }
}