<?php

namespace IssetBV\XAuthBundle\Security\Firewall;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\Security\Http\Firewall\ListenerInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\SecurityContextInterface;
use Symfony\Component\Security\Core\Authentication\AuthenticationManagerInterface;
use IssetBV\XAuthBundle\Security\Authentication\Token\XAuthToken;

class XAuthListener implements ListenerInterface
{

    protected $securityContext;
    protected $authenticationManager;
    protected $tokenName;

    public function __construct(SecurityContextInterface $securityContext, AuthenticationManagerInterface $authenticationManager, $tokenName)
    {
        $this->securityContext       = $securityContext;
        $this->authenticationManager = $authenticationManager;
        $this->tokenName             = $tokenName;
    }

    public function handle(GetResponseEvent $event)
    {
        $request = $event->getRequest();
        $token = new XAuthToken(array(), $request->headers->get($this->tokenName, false));

        try {
            $authToken = $this->authenticationManager->authenticate($token);
            $this->securityContext->setToken($authToken);
        } catch (AuthenticationException $failed) {
            $response = new JsonResponse(array('message' => $failed->getMessage()), 403);
            $event->setResponse($response);
        }
    }

}