<?php
namespace IssetBV\XAuthBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\XAuthBundle\Model\LinkInterface;

class EndpointRepository extends EntityRepository
{

    public function findActiveByLinkInterface(LinkInterface $linkInterface)
    {
        return $this->createQueryBuilder('e')
            ->where("e.link = :link")
            ->andWhere('e.dateDeactivated IS NULL')
            ->setParameter('link', $linkInterface)
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult();
    }

    public function getByConsumerKey($consumerKey)
    {
        return $this->createQueryBuilder('e')
            ->where("e.consumerKey = :consumerKey")
            ->andWhere('e.dateDeactivated IS NULL')
            ->setParameter('consumerKey', $consumerKey)
            ->getQuery()
            ->getOneOrNullResult();
    }

    public function getByToken($token)
    {
        $endpoint = $this->createQueryBuilder('e')
            ->join('e.tokens', 't')
            ->where('e.dateDeactivated IS NULL')
            ->andWhere('t.token = :token')
            ->andWhere('t.dateDeactivated IS NULL')
            ->setParameter(':token', $token)
            ->getQuery()
            ->getOneOrNullResult();
        
        return $endpoint;
    }
}