<?php
namespace IssetBV\XAuthBundle\Repository;

use Doctrine\ORM\EntityRepository;

class EndpointTokenRepository extends EntityRepository
{

    public function getByToken($token)
    {
        return $this->createQueryBuilder('e')
            ->andWhere('e.token = :token')
            ->andWhere('e.dateDeactivated IS NULL')
            ->setParameter(':token', $token)
            ->getQuery()
            ->getOneOrNullResult();
    }

    public function getActiveByLinkId($id)
    {
        return $this->createQueryBuilder('t')
            ->select('t')
            ->join('t.endpoint', 'e')
            ->where('e.id = :id')
            ->andWhere('t.dateDeactivated IS NULL')
            ->setParameter(':id', $id)
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult();
    }
}