<?php
namespace IssetBV\XAuthBundle\DependencyInjection\Security\Factory;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\DependencyInjection\DefinitionDecorator;
use Symfony\Component\Config\Definition\Builder\NodeDefinition;
use Symfony\Bundle\SecurityBundle\DependencyInjection\Security\Factory\SecurityFactoryInterface;

class XAuthFactory implements SecurityFactoryInterface
{

    public function create(ContainerBuilder $container, $id, $config, $userProvider, $defaultEntryPoint)
    {
        $providerId = 'security.authentication.provider.xauth.' . $id;
        $container->setDefinition($providerId, new DefinitionDecorator('xauth.security.authentication.provider'));
        
        $listenerId = 'security.authentication.listener.xauth.' . $id;
        $container->setDefinition($listenerId, new DefinitionDecorator('xauth.security.authentication.listener'));
        
        return array(
            $providerId,
            $listenerId,
            $defaultEntryPoint
        );
    }

    public function getPosition()
    {
        return 'pre_auth';
    }

    public function getKey()
    {
        return 'xauth';
    }

    public function addConfiguration(NodeDefinition $node)
    {}
}