<?php
namespace IssetBV\XAuthBundle\Service\Endpoint;

use IssetBV\XAuthBundle\Model\LinkInterface;
use IssetBV\XAuthBundle\Entity\Endpoint as EndpointEntity;
use IssetBV\XAuthBundle\Entity\EndpointToken;
use IssetBV\XAuthBundle\Repository\EndpointRepository;
use Doctrine\Bundle\DoctrineBundle\Registry;

class Endpoint
{

    /**
     * @var string
     */
    private $salt;

    /**
     * @var EndpointRepository
     */
    private $endpointRepository;

    private $em;

    /**
     * 
     * @param string $salt
     */
    public function __construct(Registry $doctrine, $salt)
    {
        $this->salt = $salt;
        $this->em = $doctrine->getManager();
        $this->endpointRepository = $doctrine->getRepository("IssetBVXAuthBundle:Endpoint");
    }

    public function findActiveForLink(LinkInterface $link)
    {
        $endpoint = $this->endpointRepository->findActiveByLinkInterface($link);
        if ($endpoint === null) {
            $endpoint = $this->createNewForLink($link);
            $this->em->persist($endpoint);
        }
        return $endpoint;
    }

    /**
     * @param LinkInterface $link
     * @return EndpointEntity
     */
    public function createNewForLink(LinkInterface $link)
    {
        $consumerKey = $this->generateKey();
        $privateKey = $this->generateKey();
        $endpoint = new EndpointEntity($link, $consumerKey, $privateKey);
        return $endpoint;
    }

    /**
     * 
     * @param LinkInterface $link
     * @return EndpointToken
     */
    public function getTokenForLink(LinkInterface $link)
    {
        $endpoint = $this->findActiveForLink($link);
        return $this->getTokenForEndpoint($endpoint);
    }

    /**
     * @param EndpointEntity $endpoint
     * @return EndpointToken
     */
    public function getTokenForEndpoint(EndpointEntity $endpoint)
    {
        foreach ($endpoint->getTokens() as $token) {
            /* @var $token EndpointToken */
            if ($token->isActive()) {
                return $token;
            }
        }
        $token = $this->generateKey();
        return $endpoint->addToken($token);
    }

    /**
     * @return string
     */
    private function generateKey()
    {
        return date("YmdHis") . '_' . sha1($this->salt . mt_rand(0, mt_getrandmax()) . '_' . time() . microtime(true));
    }
}