<?php

namespace IssetBV\XAuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Endpoint
 * @ORM\Table(name="issetbv_xauth_endpoints")
 * @ORM\Entity
 */
class Endpoint
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @ORM\OneToMany(targetEntity="EndpointToken", mappedBy="endpoint")
     */
    private $tokens;

    /**
     * @ORM\ManyToOne(targetEntity="IssetBV\XAuthBundle\Model\LinkInterface")
     */
    private $link;

    /**
     * @var string
     *
     * @ORM\Column(name="note", type="string", nullable=true)
     */
    private $note;

    /**
     * @var string
     *
     * @ORM\Column(name="consumer_key", type="string", nullable=false, unique=true)
     */
    private $consumerKey;

    /**
     * @var string
     *
     * @ORM\Column(name="private_key", type="string", nullable=false)
     */
    private $privateKey;

    /**
     * @var bool
     *
     * @ORM\Column(name="active", type="boolean", nullable=false)
     */
    private $active;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="datetimetz", nullable=true)
     */
    private $created;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated", type="datetimetz", nullable=true)
     */
    private $updated;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tokens = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set note
     *
     * @param string $note
     * @return Endpoint
     */
    public function setNote($note)
    {
        $this->note = $note;
    
        return $this;
    }

    /**
     * Get note
     *
     * @return string 
     */
    public function getNote()
    {
        return $this->note;
    }

    /**
     * Set consumerKey
     *
     * @param string $consumerKey
     * @return Endpoint
     */
    public function setConsumerKey($consumerKey)
    {
        $this->consumerKey = $consumerKey;
    
        return $this;
    }

    /**
     * Get consumerKey
     *
     * @return string 
     */
    public function getConsumerKey()
    {
        return $this->consumerKey;
    }

    /**
     * Set privateKey
     *
     * @param string $privateKey
     * @return Endpoint
     */
    public function setPrivateKey($privateKey)
    {
        $this->privateKey = $privateKey;
    
        return $this;
    }

    /**
     * Get privateKey
     *
     * @return string 
     */
    public function getPrivateKey()
    {
        return $this->privateKey;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return Endpoint
     */
    public function setActive($active)
    {
        $this->active = $active;
    
        return $this;
    }

    /**
     * Get active
     *
     * @return boolean 
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return Endpoint
     */
    public function setCreated($created)
    {
        $this->created = $created;
    
        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime 
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated
     * @return Endpoint
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
    
        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime 
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Add tokens
     *
     * @param \IssetBV\XAuthBundle\Entity\EndpointToken $tokens
     * @return Endpoint
     */
    public function addToken(\IssetBV\XAuthBundle\Entity\EndpointToken $tokens)
    {
        $this->tokens[] = $tokens;
    
        return $this;
    }

    /**
     * Remove tokens
     *
     * @param \IssetBV\XAuthBundle\Entity\EndpointToken $tokens
     */
    public function removeToken(\IssetBV\XAuthBundle\Entity\EndpointToken $tokens)
    {
        $this->tokens->removeElement($tokens);
    }

    /**
     * Get tokens
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokens()
    {
        return $this->tokens;
    }

    /**
     * Set link
     *
     * @param \IssetBV\XAuthBundle\Model\LinkInterface $link
     * @return Endpoint
     */
    public function setLink(\IssetBV\XAuthBundle\Model\LinkInterface $link = null)
    {
        $this->link = $link;
    
        return $this;
    }

    /**
     * Get link
     *
     * @return \IssetBV\XAuthBundle\Model\LinkInterface 
     */
    public function getLink()
    {
        return $this->link;
    }
}