<?php

namespace IssetBV\XAuthBundle\Repository;

use Doctrine\ORM\EntityRepository;

class EndpointTokenRepository extends EntityRepository
{

    public function getActiveByLinkId($id)
    {
        return $this->createQueryBuilder('t')
                        ->select('t')
                        ->join('t.endpoint', 'e')
                        ->where('e.id = :id')
                        ->andWhere('t.active = :active')
                        ->setParameter(':id', $id)
                        ->setParameter(':active', true)
                        ->setMaxResults(1)
                        ->getQuery()
                        ->getOneOrNullResult()
        ;
    }

}