<?php

namespace IssetBV\XAuthBundle\Security\Authentication;

use Symfony\Component\Security\Core\User\UserInterface;

class XAuthUser implements UserInterface
{

    private $roles;
    private $data = array();

    public function __construct(array $roles)
    {
        $this->roles = $roles;
    }

    public function setDataArray(array $data)
    {
        $this->data = $data;
    }

    public function addRole($role)
    {
        if (!in_array($role, $this->roles)) {
            $this->roles[] = $role;
        }
    }

    public function setDataItem($key, $item)
    {
        $this->data[$key] = $item;
    }

    /**
     * @deprecated since version 2.0.3
     */
    public function getDataItem($key, $default = false)
    {
        return isset($this->data[$key]) ? $this->data[$key] : $default;
    }

    public function get($key, $default = false)
    {
        return isset($this->data[$key]) ? $this->data[$key] : $default;
    }

    public function eraseCredentials()
    {
        return false;
    }

    public function getPassword()
    {
        return false;
    }

    public function getRoles()
    {
        return $this->roles;
    }

    public function getSalt()
    {
        return false;
    }

    public function getUsername()
    {
        return false;
    }

}
