<?php

namespace IssetBV\XAuthBundle\Security\Authentication\Provider;

use Symfony\Component\Security\Core\Authentication\Provider\AuthenticationProviderInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Doctrine\Bundle\DoctrineBundle\Registry;
use IssetBV\XAuthBundle\Security\Authentication\Token\XAuthToken;
use Symfony\Component\Security\Core\Role\Role;
use Symfony\Component\DependencyInjection\ContainerInterface;
use IssetBV\XAuthBundle\Security\Authentication\XAuthUser;

class XAuthProvider implements AuthenticationProviderInterface
{

    private $doctrine;
    private $provider;

    /**
     * @var \Symfony\Component\DependencyInjection\ContainerInterface
     */
    private $container;
    private $authExtra;

    public function __construct(Registry $doctrine, ContainerInterface $container, array $authExtra = array())
    {
        $this->doctrine  = $doctrine;
        $this->container = $container;
        $this->authExtra = $authExtra;
    }

    public function authenticate(TokenInterface $token)
    {
        if (!$token->getToken()) {
            throw new AuthenticationException('No token given');
        }

        $endpoint = $this
                ->doctrine
                ->getManager()
                ->createQueryBuilder()
                ->from('IssetBVXAuthBundle:Endpoint', 'e')
                ->select('e')
                ->join('e.tokens', 't')
                ->where('e.active = true')
                ->andWhere('t.token = :token')
                ->andWhere('t.active = true')
                ->setParameter(':token', $token->getToken())
                ->getQuery()
                ->getOneOrNullResult();

        /* @var $endpoint \IssetBV\XAuthBundle\Entity\Endpoint */
        if (empty($endpoint)) {
            throw new AuthenticationException('Token not valid');
        }


        if (!$endpoint->getLink()->getActive()) {
            throw new AuthenticationException('Endpoint link not found');
        }

        $user = new XAuthUser(array(new Role('ROLE_XAUTH_USER')));
        $user->setDataItem('base', $data);

        foreach ($this->authExtra as $authExtra) {
            $this->handleAuth($authExtra, $user);
        }




        $returnToken = new XAuthToken($user->getRoles(), $token->getToken());
        $returnToken->setUser($user);
        return $returnToken;
    }

    private function handleAuth($authExtra, $user)
    {
        if (!$this->container->has($authExtra)) {
            return false;
        }
        $provider = $this->container->get($authExtra);

        if (!($provider instanceof XAuthProviderExtra)) {
            return false;
        }
        /* @var $provider \IssetBV\XAuthBundle\Security\Authentication\Provider\XAuthProviderExtra */
        return $provider->auth($this->container->get('request'), $user);
    }

    public function supports(TokenInterface $token)
    {
        return $token instanceof XAuthToken;
    }

}