<?php

namespace IssetBV\XAuthBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use IssetBV\XAuthBundle\Entity\EndpointToken;
use Symfony\Component\HttpKernel\Exception\HttpException;

class AuthenticationController extends Controller
{

    public function loginAction(Request $request)
    {
        if (!$request->request->get('consumer_key', false) || !$request->request->get('time', false) || !$request->request->get('hash', false)) {
            throw new HttpException(400, json_encode(array('message' => 'missing parameters')));
        }
        $endpoint = $this->getDoctrine()->getRepository('IssetBVXAuthBundle:Endpoint')->findOneBy(array('consumerKey' => $request->request->get('consumer_key'), 'active' => 1));
        /* @var $endpoint \IssetBV\XAuthBundle\Entity\Endpoint */

        if ($endpoint == null) {
            return new JsonResponse(array('message' => 'Consumer key denied'), 403);
        }

        $calculatedHash = $this->container->get('xauth.security.hasher')->getHash($endpoint->getConsumerKey(), $endpoint->getPrivateKey(), $request->request->get('time'));
        if ($request->request->get('hash') !== $calculatedHash) {
            return new JsonResponse(array('message' => 'Hash doesn\'t validate'), 403);
        }

        if (!$endpoint->getLink()->getActive()) {
            return new JsonResponse(array('message' => 'Access denied link not active'), 403);
        }

        $endpointToken = new EndpointToken();
        $endpointToken->setActive(1);
        $endpointToken->setEndpoint($endpoint);
        $endpointToken->setToken($this->get('xauth.security.token.generator')->generate($endpoint->getConsumerKey(), $endpoint->getPrivateKey(), $request->request->get('time'), $this->container->getParameter('secret')));
        $endpointToken->setCreated(new \DateTime());
        $em            = $this->getDoctrine()->getManager();
        $em->persist($endpointToken);
        $em->flush();

        return new JsonResponse(array('message' => 'Access granted', 'token' => $endpointToken->getToken(), 'roles' => $endpointToken->getEndpoint()->getLink()->getRoles(), 'uuid' => $endpointToken->getEndpoint()->getLink()->getUUID()));
    }

    public function logoutAction($token)
    {
        $jsonResponse = new JsonResponse(array("message" => "success"));

        $em = $this->getDoctrine()->getManager();

        $token = $em->createQueryBuilder()
                ->from('IssetBVXAuthBundle:EndpointToken', 'e')
                ->select('e')
                ->andWhere('e.token = :token')
                ->andWhere('e.active = true')
                ->setParameter(':token', $token)
                ->getQuery()
                ->getOneOrNullResult();

        if (empty($token)) {
            return $jsonResponse;
        }

        $token->setActive(false);
        $em->flush();

        return $jsonResponse;
    }

}
