<?php

namespace IssetBv\XAuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EndpointToken
 *
 * @ORM\Table(name="issetbv_xauth_endpoint_tokens", indexes={@ORM\Index(name="token_search", columns={"token", "active"})})
 * @ORM\Entity(repositoryClass="IssetBv\XAuthBundle\Repository\EndpointTokenRepository")
 */
class EndpointToken
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="token", type="string", nullable=false)
     */
    private $token;

    /**
     * @var bool
     *
     * @ORM\Column(name="active", type="boolean", nullable=false)
     */
    private $active;

    /**
     * @ORM\ManyToOne(targetEntity="Endpoint", inversedBy="tokens")
     * @ORM\JoinColumn(name="issetbv_xauth_endpoint_id", referencedColumnName="id", nullable=false)
     */
    private $endpoint;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="datetimetz", nullable=true)
     */
    private $created;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated", type="datetimetz", nullable=true)
     */
    private $updated;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set token
     *
     * @param string $token
     * @return EndpointToken
     */
    public function setToken($token)
    {
        $this->token = $token;

        return $this;
    }

    /**
     * Get token
     *
     * @return string 
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return EndpointToken
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * Get active
     *
     * @return boolean 
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return EndpointToken
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime 
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated
     * @return EndpointToken
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;

        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime 
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Set endpoint
     *
     * @param \IssetBv\XAuthBundle\Entity\Endpoint $endpoint
     * @return EndpointToken
     */
    public function setEndpoint(\IssetBv\XAuthBundle\Entity\Endpoint $endpoint)
    {
        $this->endpoint = $endpoint;

        return $this;
    }

    /**
     * Get endpoint
     *
     * @return \IssetBv\XAuthBundle\Entity\Endpoint 
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

}