<?php

namespace IssetBv\XAuthBundle\Repository;

use Doctrine\ORM\EntityRepository;

class EndpointTokenRepository extends EntityRepository
{

    public function getActiveByLinkId($linkId)
    {
        return $this->createQueryBuilder('t')
                        ->select('t')
                        ->join('t.endpoint', 'e')
                        ->where('e.link_id = :linkId')
                        ->andWhere('t.active = :active')
                        ->setParameter(':linkId', $linkId)
                        ->setParameter(':active', true)
                        ->setMaxResults(1)
                        ->getQuery()
                        ->getOneOrNullResult()
        ;
    }

}