<?php

namespace IssetBv\XAuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Endpoint
 * @ORM\Table(name="issetbv_xauth_endpoints")
 * @ORM\Entity
 */
class Endpoint
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @ORM\OneToMany(targetEntity="EndpointToken", mappedBy="endpoint")
     */
    private $tokens;

    /**
     *
     * @ORM\Column(name="link_id", type="integer", nullable=false)
     */
    private $link_id;

    /**
     * @var string
     *
     * @ORM\Column(name="note", type="string", nullable=true)
     */
    private $note;

    /**
     * @var string
     *
     * @ORM\Column(name="consumer_key", type="string", nullable=false)
     */
    private $consumerKey;

    /**
     * @var string
     *
     * @ORM\Column(name="private_key", type="string", nullable=false)
     */
    private $privateKey;

    /**
     * @var bool
     *
     * @ORM\Column(name="active", type="boolean", nullable=false)
     */
    private $active;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="datetimetz", nullable=true)
     */
    private $created;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated", type="datetimetz", nullable=true)
     */
    private $updated;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tokens = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set note
     *
     * @param string $note
     * @return Endpoint
     */
    public function setNote($note)
    {
        $this->note = $note;

        return $this;
    }

    /**
     * Get note
     *
     * @return string 
     */
    public function getNote()
    {
        return $this->note;
    }

    /**
     * Set consumerKey
     *
     * @param string $consumerKey
     * @return Endpoint
     */
    public function setConsumerKey($consumerKey)
    {
        $this->consumerKey = $consumerKey;

        return $this;
    }

    /**
     * Get consumerKey
     *
     * @return string 
     */
    public function getConsumerKey()
    {
        return $this->consumerKey;
    }

    /**
     * Set privateKey
     *
     * @param string $privateKey
     * @return Endpoint
     */
    public function setPrivateKey($privateKey)
    {
        $this->privateKey = $privateKey;

        return $this;
    }

    /**
     * Get privateKey
     *
     * @return string 
     */
    public function getPrivateKey()
    {
        return $this->privateKey;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return Endpoint
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * Get active
     *
     * @return boolean 
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return Endpoint
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime 
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated
     * @return Endpoint
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;

        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime 
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Add tokens
     *
     * @param \IssetBv\XAuthBundle\Entity\EndpointToken $tokens
     * @return Endpoint
     */
    public function addToken(\IssetBv\XAuthBundle\Entity\EndpointToken $tokens)
    {
        $this->tokens[] = $tokens;

        return $this;
    }

    /**
     * Remove tokens
     *
     * @param \IssetBv\XAuthBundle\Entity\EndpointToken $tokens
     */
    public function removeToken(\IssetBv\XAuthBundle\Entity\EndpointToken $tokens)
    {
        $this->tokens->removeElement($tokens);
    }

    /**
     * Get tokens
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokens()
    {
        return $this->tokens;
    }


    /**
     * Set link_id
     *
     * @param integer $linkId
     * @return Endpoint
     */
    public function setLinkId($linkId)
    {
        $this->link_id = $linkId;
    
        return $this;
    }

    /**
     * Get link_id
     *
     * @return integer 
     */
    public function getLinkId()
    {
        return $this->link_id;
    }
}