<?php

namespace IssetBv\XAuthBundle\Security\Authentication\Provider;

use Symfony\Component\Security\Core\Authentication\Provider\AuthenticationProviderInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Doctrine\Bundle\DoctrineBundle\Registry;
use IssetBv\XAuthBundle\Security\Authentication\Token\XAuthToken;
use IssetBv\XAuthBundle\Security\Provider;

class XAuthProvider implements AuthenticationProviderInterface
{

    private $userProvider;
    private $doctrine;
    private $provider;

    public function __construct(UserProviderInterface $userProvider, Registry $doctrine, Provider $provider)
    {
        $this->userProvider = $userProvider;
        $this->doctrine     = $doctrine;
        $this->provider     = $provider;
    }

    public function authenticate(TokenInterface $token)
    {
        if (!$token->getToken()) {
            throw new AuthenticationException('No token given');
        }

        $endpoint = $this
                ->doctrine
                ->getManager()
                ->createQueryBuilder()
                ->from('IssetBvXAuthBundle:Endpoint', 'e')
                ->select('e')
                ->join('e.tokens', 't')
                ->where('e.active = true')
                ->andWhere('t.token = :token')
                ->andWhere('t.active = true')
                ->setParameter(':token', $token->getToken())
                ->getQuery()
                ->getOneOrNullResult();

        /* @var $endpoint \IssetBv\XAuthBundle\Entity\Endpoint */
        if (empty($endpoint)) {
            throw new AuthenticationException('Token not valid');
        }

        $data = $this->provider->getById($endpoint->getLinkId());
        if (empty($data)) {
            throw new AuthenticationException('Endpoint link not found');
        }

        $token->setAttribute('data', $data);
        return $token;
    }

    public function supports(TokenInterface $token)
    {
        return $token instanceof XAuthToken;
    }

}