<?php

namespace IssetBv\XAuthBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use IssetBv\XAuthBundle\Entity\EndpointToken;

class AuthenticationController extends Controller
{

    public function loginAction(Request $request)
    {
        if (!$request->request->get('consumer_key', false) || !$request->request->get('time', false) || !$request->request->get('hash', false)) {
            return new JsonResponse(array('message' => 'missing parameters'), 400);
        }

        $endpoint = $this->getDoctrine()->getRepository('IssetBvXAuthBundle:Endpoint')->findOneBy(array('consumerKey' => $request->request->get('consumer_key'), 'active' => 1));
        /* @var $endpoint \IssetBv\XAuthBundle\Entity\Endpoint */

        if (!$endpoint) {
            return new JsonResponse(array('message' => 'Consumer key denied'), 403);
        }

        $provider = $this->get('xauth.security.provider');
        if (!$provider->getById($endpoint->getLinkId())) {
            return new JsonResponse(array('message' => 'Access denied link not active'), 403);
        }


        if ($request->request->get('hash') !== $this->container->get('xauth.security.hasher')->getHash($endpoint->getConsumerKey(), $endpoint->getPrivateKey(), $request->request->get('time'))) {
            return new JsonResponse(array('message' => 'Hash doesn\'t validate'), 403);
        }

        $endpointToken = new EndpointToken();
        $endpointToken->setActive(1);
        $endpointToken->setEndpoint($endpoint);
        $endpointToken->setToken(sha1('ZjwebnrqjwkebruhUAF' . $request->request->get('time') . '' . $endpoint->getPrivateKey() . '' . $endpoint->getConsumerKey() . mt_rand(0, mt_getrandmax())));
        $em            = $this->getDoctrine()->getManager();
        $em->persist($endpointToken);
        $em->flush();

        return new JsonResponse(array('message' => 'Access granted', 'token' => $endpointToken->getToken()));
    }

    public function logoutAction($token)
    {
        $jsonResponse = new JsonResponse(array("message" => "success"));

        $em = $this->getDoctrine()->getManager();

        $token = $em->createQueryBuilder()
                ->from('IssetBvXAuthBundle:EndpointToken', 'e')
                ->select('e')
                ->andWhere('e.token = :token')
                ->andWhere('e.active = true')
                ->setParameter(':token', $token)
                ->getQuery()
                ->getOneOrNullResult();

        if (empty($token)) {
            return $jsonResponse;
        }

        $token->setActive(false);
        $em->flush();

        return $jsonResponse;
    }

}
