<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClient\Response\Validator\Exception;

use Throwable;

class MissingFieldsException extends ValidatorException
{
    /**
     * @var array
     */
    private $missingFields;

    public function __construct(array $missingFields, string $message = '', int $code = 0, Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->missingFields = $missingFields;
    }

    /**
     * @return array
     */
    public function getMissingFields(): array
    {
        return $this->missingFields;
    }
}
