<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClientBundle\Service;

use IssetBV\VideoStreamClient\HttpClient;
use IssetBV\VideoStreamClient\VideoStreamClient;

class VideoStreamClientFactory
{
    /**
     * @var HttpClient
     */
    private $httpClient;

    /**
     * @var VideoStreamClient[]
     */
    private $cache = [];

    public function __construct(HttpClient $httpClient)
    {
        $this->httpClient = $httpClient;
    }

    public function getForToken(string $token): VideoStreamClient
    {
        if (array_key_exists($token, $this->cache)) {
            return $this->cache[$token];
        }

        return $this->cache[$token] = new VideoStreamClient($this->httpClient, $token);
    }
}
