<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClientBundle\DependencyInjection;

use IssetBV\VideoStreamClient\HttpClient;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class IssetBVVideoStreamClientExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $client = $container->register(HttpClient::class);
        $client->setAutowired(true);
        $client->setArgument('$baseUrl', $config['url']);
    }
}
