<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClient\Response\Profile;

use IssetBV\VideoStreamClient\Response\Validator\Exception\MissingFieldsException;
use IssetBV\VideoStreamClient\Response\Validator\Validator;
use Psr\Http\Message\ResponseInterface;

class Profile
{
    /**
     * @var array
     */
    private $data;

    public function __construct(array $data)
    {
        self::validate($data);
        $this->data = $data;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    public function getVersion(): string
    {
        return $this->data['version'];
    }

    public function getName(): string
    {
        return $this->data['name'];
    }

    /**
     * @param array $data
     *
     * @throws MissingFieldsException
     */
    public static function validate(array $data)
    {
        Validator::checkFields($data, [
            'version',
            'name',
        ]);
    }

    public static function createFromJson(string $json): self
    {
        return new self(json_decode($json, true));
    }

    public static function createFromResponse(ResponseInterface $response): self
    {
        return self::createFromJson((string) $response->getBody());
    }

    public static function createMultiFromResponse(ResponseInterface $response): array
    {
        $return = [];
        $data = json_decode((string) $response->getBody(), true);
        foreach ($data as $item) {
            $return[] = new self($item);
        }

        return $return;
    }
}
