<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClient\Response\LiveStream;

use IssetBV\VideoStreamClient\Response\LiveStream\Output\Output;
use IssetBV\VideoStreamClient\Response\Validator\Exception\MissingFieldsException;
use IssetBV\VideoStreamClient\Response\Validator\Validator;
use Psr\Http\Message\ResponseInterface;

class LiveStream
{
    private $data;
    /**
     * @var Output[]
     */
    private $outputs;

    public function __construct(array $data)
    {
        self::validate($data);
        $this->data = $data;
        $this->outputs = [];
        foreach ($data['outputs'] as $output) {
            $this->outputs[] = new Output($output);
        }
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    public function getVersion(): string
    {
        return $this->data['version'];
    }

    public function getUUID(): string
    {
        return $this->data['uuid'];
    }

    public function getStatus(): string
    {
        return $this->data['status'];
    }

    public function getUrl(): string
    {
        return $this->data['url'];
    }

    /**
     * @return Output[]
     */
    public function getOutputs(): array
    {
        return $this->outputs;
    }

    /**
     * @param array $data
     *
     * @throws MissingFieldsException
     */
    public static function validate(array $data)
    {
        Validator::checkFields($data, [
            'version',
            'uuid',
            'status',
            'url',
            'outputs',
        ]);
    }

    public static function createFromJson(string $json): self
    {
        return new self(json_decode($json, true));
    }

    public static function createFromResponse(ResponseInterface $response): self
    {
        return self::createFromJson((string) $response->getBody());
    }
}
