<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClient\Response\Validator;

use IssetBV\VideoStreamClient\Response\Validator\Exception\MissingFieldsException;

class Validator
{
    /**
     * @param array $checkArray
     * @param array $fields
     *
     * @throws MissingFieldsException
     */
    public static function checkFields(array $checkArray, array $fields)
    {
        $missingFields = [];
        foreach ($fields as $field) {
            if (!array_key_exists($field, $checkArray)) {
                $missingFields[] = $field;
            }
        }

        if (0 !== \count($missingFields)) {
            throw new MissingFieldsException($missingFields, 'missing fields[' . implode(', ', $missingFields) . ']');
        }
    }
}
