<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClient\Request\LiveStream\Quick;

use DateTime;
use JsonSerializable;

class QuickAdd implements JsonSerializable
{
    /**
     * @var string
     */
    private $profile;
    /**
     * @var string[]
     */
    private $callbacks = [];
    /**
     * @var string|null
     */
    private $name;
    /**
     * @var DateTime|null
     */
    private $startDate;
    /**
     * @var DateTime|null
     */
    private $endDate;
    /**
     * @var string|null
     */
    private $folderPath;

    public function __construct(string $profile)
    {
        $this->profile = $profile;
    }

    /**
     * @return string
     */
    public function getProfile(): string
    {
        return $this->profile;
    }

    /**
     * @param string $profile
     */
    public function setProfile(string $profile)
    {
        $this->profile = $profile;
    }

    public function addCallback(string $callback)
    {
        $this->callbacks[] = $callback;
    }

    /**
     * @return string[]
     */
    public function getCallbacks(): array
    {
        return $this->callbacks;
    }

    /**
     * @param string[] $callbacks
     */
    public function setCallbacks(array $callbacks)
    {
        $this->callbacks = $callbacks;
    }

    /**
     * @return null|string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param null|string $name
     */
    public function setName(string $name = null)
    {
        $this->name = $name;
    }

    /**
     * @return DateTime|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }

    /**
     * @param DateTime|null $startDate
     */
    public function setStartDate(DateTime $startDate = null)
    {
        $this->startDate = $startDate;
    }

    /**
     * @return DateTime|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }

    /**
     * @param DateTime|null $endDate
     */
    public function setEndDate(DateTime $endDate = null)
    {
        $this->endDate = $endDate;
    }

    /**
     * @return null|string
     */
    public function getFolderPath()
    {
        return $this->folderPath;
    }

    /**
     * @param null|string $folderPath
     */
    public function setFolderPath(string $folderPath = null)
    {
        $this->folderPath = $folderPath;
    }

    public function jsonSerialize()
    {
        return [
            'profile' => $this->profile,
            'callbacks' => $this->callbacks,
            'name' => $this->name,
            'start_date' => null !== $this->startDate ? $this->startDate->format('c') : null,
            'end_date' => null !== $this->endDate ? $this->endDate->format('c') : null,
            'folder_path' => $this->folderPath,
        ];
    }
}
