<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClient\Request\LiveStream\Finish;

use DateTime;
use JsonSerializable;

class FinishData implements JsonSerializable
{
    /**
     * @var DateTime|null
     */
    private $startDate;
    /**
     * @var DateTime|null
     */
    private $endDate;
    /**
     * @var string|null
     */
    private $name;

    /**
     * @return null|string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param null|string $name
     */
    public function setName(string $name = null)
    {
        $this->name = $name;
    }

    /**
     * @return DateTime|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }

    /**
     * @param DateTime|null $startDate
     */
    public function setStartDate(DateTime $startDate = null)
    {
        $this->startDate = $startDate;
    }

    /**
     * @return DateTime|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }

    /**
     * @param DateTime|null $endDate
     */
    public function setEndDate(DateTime $endDate = null)
    {
        $this->endDate = $endDate;
    }

    public function jsonSerialize()
    {
        return [
            'name' => $this->name,
            'start_date' => null !== $this->startDate ? $this->startDate->format('c') : null,
            'end_date' => null !== $this->endDate ? $this->endDate->format('c') : null,
        ];
    }
}
