<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClient\Response\LiveStream\Output\Archive\Publish;

use DateTime;
use IssetBV\VideoStreamClient\Response\Validator\Validator;

class Publish
{
    /**
     * @var array
     */
    private $data;

    public function __construct(array $data)
    {
        self::validate($data);
        $this->data = $data;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    public function getVersion(): string
    {
        return $this->data['version'];
    }

    public function getUUID(): string
    {
        return $this->data['uuid'];
    }

    /**
     * @return string|null
     */
    public function getPublishIdentifier()
    {
        return $this->data['publish_identifier'];
    }

    public function getStatus(): string
    {
        return $this->data['status'];
    }

    /**
     * @return string|null
     */
    public function getPreset()
    {
        return $this->data['preset'];
    }

    public function getExtension(): string
    {
        return $this->data['extension'];
    }

    public function getDateUpdated(): DateTime
    {
        return new DateTime($this->data['date_updated']);
    }

    /**
     * @param array $data
     *
     * @throws \IssetBV\VideoStreamClient\Response\Validator\Exception\MissingFieldsException
     */
    public static function validate(array $data)
    {
        Validator::checkFields($data, [
            'version',
            'uuid',
            'publish_identifier',
            'status',
            'date_updated',
            'preset',
            'extension',
        ]);
    }
}
