<?php

declare(strict_types=1);

namespace IssetBV\VideoStreamClient\Response\LiveStream\Output\Archive;

use DateTime;
use IssetBV\VideoStreamClient\Response\LiveStream\Output\Archive\Publish\Publish;
use IssetBV\VideoStreamClient\Response\Validator\Exception\MissingFieldsException;
use IssetBV\VideoStreamClient\Response\Validator\Validator;

class Archive
{
    /**
     * @var array
     */
    private $data;
    /**
     * @var Publish[]
     */
    private $publishes;

    public function __construct(array $data)
    {
        self::validate($data);
        $this->data = $data;
        $this->publishes = [];
        foreach ($data['publishes'] as $publish) {
            $this->publishes[] = new Publish($publish);
        }
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    public function getVersion(): string
    {
        return $this->data['version'];
    }

    public function getUUID(): string
    {
        return $this->data['uuid'];
    }

    /**
     * @return string|null
     */
    public function getArchiveIdentifier()
    {
        return $this->data['archive_identifier'];
    }

    public function getStatus(): string
    {
        return $this->data['status'];
    }

    public function getDateUpdated(): DateTime
    {
        return new DateTime($this->data['date_updated']);
    }

    /**
     * @return Publish[]
     */
    public function getPublishes(): array
    {
        return $this->publishes;
    }

    /**
     * @param array $data
     *
     * @throws MissingFieldsException
     */
    public static function validate(array $data)
    {
        Validator::checkFields($data, [
            'version',
            'uuid',
            'archive_identifier',
            'status',
            'date_updated',
            'publishes',
        ]);
    }
}
