<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClientBundle\Service;

use IssetBV\VideoPublisherClient\VideoPublisherClient;
use IssetBV\VideoPublisherClient\VideoPublisherHttpClient;
use IssetBV\VideoPublisherClientBundle\DependencyInjection\IssetBVVideoPublisherClientExtension;
use Psr\Container\ContainerInterface;

class VideoPublisherClientFactory
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var VideoPublisherClient[]
     */
    private $cache = [];

    /**
     * @var VideoPublisherHttpClient
     */
    private $httpClient;

    public function __construct(ContainerInterface $container, VideoPublisherHttpClient $httpClient)
    {
        $this->container = $container;
        $this->httpClient = $httpClient;
    }

    public function getForName(string $name): VideoPublisherClient
    {
        return $this->container->get(IssetBVVideoPublisherClientExtension::CLIENT_PREFIX . $name);
    }

    public function getForToken(string $token): VideoPublisherClient
    {
        if (!array_key_exists($token, $this->cache)) {
            $this->cache[$token] = new VideoPublisherClient($this->httpClient, $token);
        }

        return $this->cache[$token];
    }
}
