<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClientBundle\DependencyInjection;

use IssetBV\VideoPublisherClient\VideoPublisherClient;
use IssetBV\VideoPublisherClient\VideoPublisherHttpClient;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class IssetBVVideoPublisherClientExtension extends Extension
{
    const CLIENT_PREFIX = VideoPublisherClient::class . '_';

    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $client = $container->register(VideoPublisherHttpClient::class);
        $client->setAutowired(true);
        $client->setArgument('$baseUrl', $config['url']);

        foreach ($config['publishers'] as $publisherName => $token) {
            $id = self::CLIENT_PREFIX . $publisherName;
            $publisher = $container->register($id, VideoPublisherClient::class);
            $publisher->setAutowired(true);
            $publisher->setArgument('$token', $token);
            if ($config['default'] === $publisherName) {
                $container->setAlias(VideoPublisherClient::class, $id);
            }
        }
    }

    public function getAlias(): string
    {
        return 'video_publisher';
    }
}
