<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherBundle\Service;

use IssetBV\VideoPublisherClient\VideoPublisherClient;
use IssetBV\XAuthClient\Connection\ConnectionInterface;
use IssetBV\XAuthClient\Security\Exception\TokenNotCreatedException;
use IssetBV\XAuthClient\Security\Token;
use IssetBV\XAuthClient\Security\TokenManager;

/**
 * Class VideoPublisherClientFactory.
 */
class VideoPublisherClientFactory
{
    /**
     * @var ConnectionInterface
     */
    private $connection;
    /**
     * @var TokenManager
     */
    private $tokenManager;
    /**
     * @var string
     */
    private $url;

    /**
     * VideoPublisherClientFactory constructor.
     *
     * @param ConnectionInterface $connection
     * @param TokenManager $tokenManager
     * @param string $url
     */
    public function __construct(ConnectionInterface $connection, TokenManager $tokenManager, string $url)
    {
        $this->connection = $connection;
        $this->tokenManager = $tokenManager;
        $this->url = $url;
    }

    /**
     * @param string $publicKey
     * @param string $privateKey
     *
     * @throws TokenNotCreatedException
     *
     * @return VideoPublisherClient
     */
    public function getFor(string $publicKey, string $privateKey): VideoPublisherClient
    {
        $token = $this->tokenManager->getToken($publicKey, $privateKey);

        return $this->getForToken($token);
    }

    /**
     * @param Token $token
     *
     * @return VideoPublisherClient
     */
    public function getForToken(Token $token): VideoPublisherClient
    {
        return new VideoPublisherClient($this->connection, $token, $this->url);
    }
}
