<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Response\Data;

class PublishListResult
{
    /**
     * @var int
     */
    private $total;
    /**
     * @var int
     */
    private $from;
    /**
     * @var int
     */
    private $size;
    /**
     * @var Publish[]
     */
    private $results;

    public function __construct(int $total, int $from, int $size, array $results)
    {
        $this->total = $total;
        $this->from = $from;
        $this->size = $size;
        $this->results = $results;
    }

    /**
     * @return int
     */
    public function getTotal(): int
    {
        return $this->total;
    }

    /**
     * @return int
     */
    public function getFrom(): int
    {
        return $this->from;
    }

    /**
     * @return int
     */
    public function getSize(): int
    {
        return $this->size;
    }

    /**
     * @return Publish[]
     */
    public function getResults(): array
    {
        return $this->results;
    }
}
