<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Response\Data;

/**
 * @author Bart Malestein <bart@isset.nl>
 */
/**
 * Class Playlist.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class Playlist
{
    /**
     * @var string
     */
    private $url;

    /**
     * @var string
     */
    private $name;

    /**
     * Playlist constructor.
     *
     * @param $name
     * @param $url
     */
    public function __construct(string $name, string $url)
    {
        $this->name = $name;
        $this->url = $url;
    }

    /**
     * @return string
     */
    public function getUrl(): string
    {
        return $this->url;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }
}
