<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Request;

class Stream implements StreamInterface
{
    /**
     * @var string
     */
    private $fileName;
    /**
     * @var array
     */
    private $files = [];
    /**
     * @var array
     */
    private $extraFields = [];
    /**
     * @var string
     */
    private $identifier;
    /**
     * @var string
     */
    private $description;
    /**
     * @var string
     */
    private $callbackUrl;

    public function __construct(
        string $fileName,
        array $files = [],
        array $extraFields = [],
        string $identifier = null,
        string $description = null,
        string $callbackUrl = null
    ) {
        $this->fileName = $fileName;
        $this->identifier = $identifier;
        $this->description = $description;
        $this->callbackUrl = $callbackUrl;
        foreach ($files as $file) {
            $this->addFile($file);
        }
        foreach ($extraFields as $extraField) {
            $this->addExtraField($extraField);
        }
    }

    /**
     * @return string
     */
    public function getFilename(): string
    {
        return $this->fileName;
    }

    /**
     * @return string|null
     */
    public function getCallbackUrl()
    {
        return $this->callbackUrl;
    }

    /**
     * @param string $callbackUrl
     */
    public function setCallbackUrl(string $callbackUrl)
    {
        $this->callbackUrl = $callbackUrl;
    }

    /**
     * @param FileInterface $file
     */
    public function addFile(FileInterface $file)
    {
        $this->files[] = $file;
    }

    /**
     * @return FileInterface[]
     */
    public function getFiles(): array
    {
        return $this->files;
    }

    /**
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @param string $identifier
     */
    public function setIdentifier(string $identifier)
    {
        $this->identifier = $identifier;
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description)
    {
        $this->description = $description;
    }

    /**
     * @return ExtraFieldInterface[]
     */
    public function getExtraField(): array
    {
        return $this->extraFields;
    }

    /**
     * @param ExtraFieldInterface $extraField
     */
    public function addExtraField(ExtraFieldInterface $extraField)
    {
        $this->extraFields[] = $extraField;
    }
}
