<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Exception;

use Exception;
use Psr\Http\Message\ResponseInterface;

class AccessDeniedException extends Exception
{
    /**
     * @var ResponseInterface
     */
    private $response;

    public function __construct(ResponseInterface $response, string $message = '')
    {
        parent::__construct($message);
        $this->response = $response;
    }

    /**
     * @return ResponseInterface
     */
    public function getResponse(): ResponseInterface
    {
        return $this->response;
    }
}
