<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Response\Data;

use DateTime;

/**
 * @author Tim Fennis <tim@isset.nl>
 * @author Bart Malestein <bart@isset.nl>
 */
class Publish
{
    /**
     * @var DateTime
     */
    private $dateCreated;

    /**
     * @var bool
     */
    private $enabled;

    /**
     * @var bool
     */
    private $viewable;

    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $uuid;

    /**
     * @var Playout
     */
    private $playout;

    /**
     * @var string
     */
    private $streamName;

    /**
     * @var string|null
     */
    private $identifier;

    /**
     * @var string|null
     */
    private $description;

    /**
     * @var Asset[]
     */
    private $assets;

    /**
     * Publish constructor.
     *
     * @param string $uuid
     * @param string $streamName
     * @param string $status
     * @param bool $enabled
     * @param DateTime $dateCreated
     * @param bool $viewable
     * @param Playout $playout
     * @param $identifier
     * @param $description
     * @param $assets
     */
    public function __construct(
        string $uuid,
        string $streamName,
        string $status,
        bool $enabled,
        DateTime $dateCreated,
        bool $viewable,
        Playout $playout = null,
        string $identifier = null,
        string $description = null,
        array $assets
    ) {
        $this->uuid = $uuid;
        $this->status = $status;
        $this->enabled = $enabled;
        $this->viewable = $viewable;
        $this->playout = $playout;
        $this->dateCreated = $dateCreated;
        $this->streamName = $streamName;
        $this->identifier = $identifier;
        $this->description = $description;
        $this->assets = $assets;
    }

    /**
     * @return DateTime
     */
    public function getDateCreated(): DateTime
    {
        return $this->dateCreated;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    /**
     * @return bool
     */
    public function isViewable(): bool
    {
        return $this->viewable;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return Playout
     */
    public function getPlayout(): Playout
    {
        return $this->playout;
    }

    /**
     * @return string
     */
    public function getStreamName(): string
    {
        return $this->streamName;
    }

    /**
     * @return null|string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @return null|string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @return Asset[]
     */
    public function getAssets(): array
    {
        return $this->assets;
    }
}
