<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient;

use IssetBV\Http\Client\ClientInterface;
use Psr\Http\Message\ResponseInterface;

class VideoPublisherHttpClient
{
    /**
     * @var string
     */
    private $baseUrl;
    /**
     * @var ClientInterface
     */
    private $client;

    public function __construct(ClientInterface $client, string $baseUrl)
    {
        $this->baseUrl = rtrim($baseUrl, '/');
        $this->client = $client;
    }

    public function call(string $method, string $uri, array $headers = [], $body = null): ResponseInterface
    {
        $request = $this->client->create($method, $this->withBaseUrl($uri), $headers, $body);

        return $this->client->call($request);
    }

    private function withBaseUrl(string $url): string
    {
        return $this->baseUrl . '/' . ltrim($url, '/');
    }
}
