<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Response\Data;

/**
 * Class PlaylistResult.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class PlaylistResult
{
    /**
     * @var int
     */
    private $total;
    /**
     * @var int
     */
    private $from;
    /**
     * @var int
     */
    private $size;
    /**
     * @var Playlist[]
     */
    private $results;

    /**
     * PlaylistResult constructor.
     *
     * @param int $total
     * @param int $from
     * @param int $size
     * @param Playlist[] $results
     */
    public function __construct(int $total, int $from, int $size, array $results)
    {
        $this->total = $total;
        $this->from = $from;
        $this->size = $size;
        $this->results = $results;
    }

    /**
     * @return int
     */
    public function getTotal(): int
    {
        return $this->total;
    }

    /**
     * @return int
     */
    public function getFrom(): int
    {
        return $this->from;
    }

    /**
     * @return int
     */
    public function getSize(): int
    {
        return $this->size;
    }

    /**
     * @return Playlist[]
     */
    public function getResults(): array
    {
        return $this->results;
    }
}
