<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Request;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
interface StreamInterface
{
    /**
     * @return string
     */
    public function getFilename(): string;

    /**
     * @return string|null
     */
    public function getCallbackUrl();

    /**
     * @return FileInterface[]
     */
    public function getFiles(): array;

    /**
     * @return string|null
     */
    public function getIdentifier();

    /**
     * @return string|null
     */
    public function getDescription();

    /**
     * @return ExtraFieldInterface[]
     */
    public function getExtraField(): array;
}
